#version 430 core

in vec2 TexCoords;

layout (binding = 0) uniform sampler2D bloomInput;

uniform int SCR_HEIGHT;
uniform int SCR_WIDTH;

layout(r32i, binding = 1) uniform iimage2D atomicOutputTex;

float sampleCount = 5.0;

void main()
{             
	float bloomMagnitude = (texture(bloomInput, TexCoords).a * sampleCount);

	ivec2 coords = ivec2(TexCoords * vec2(SCR_WIDTH, SCR_HEIGHT));

	int bloomAmount = int(bloomMagnitude);

	
	if(bloomMagnitude > 0.0){

		ivec2 offsetY = ivec2(0, 1) * bloomAmount;
		ivec2 offsetX = ivec2(1, 0) * bloomAmount;

		
		int plusXVal = imageAtomicCompSwap(atomicOutputTex, (coords + offsetX), 999, bloomAmount);
		int plusYVal = imageAtomicCompSwap(atomicOutputTex, (coords + offsetY), 999, bloomAmount);
		int minusXVal = imageAtomicCompSwap(atomicOutputTex, (coords - offsetX), 999, bloomAmount);
		int minusYVal = imageAtomicCompSwap(atomicOutputTex, (coords - offsetY), 999, bloomAmount);
		

		if(plusXVal < bloomAmount && plusXVal != 999){		
			imageAtomicCompSwap(atomicOutputTex, (coords + offsetX), plusXVal, bloomAmount);
		}

		if(plusYVal < bloomAmount && plusYVal != 999){		
			imageAtomicCompSwap(atomicOutputTex, (coords + offsetY), plusYVal, bloomAmount);
		}

		if(minusXVal < bloomAmount && minusXVal != 999){		
			imageAtomicCompSwap(atomicOutputTex, (coords - offsetX), minusXVal, bloomAmount);
		}

		if(minusYVal < bloomAmount && minusYVal != 999){		
			imageAtomicCompSwap(atomicOutputTex, (coords - offsetY), minusYVal, bloomAmount);
		}

	}

}